/*
Copyright © 2006-2007 Apple Inc.  All Rights Reserved.

IMPORTANT:  This Apple software ("Apple Software") is supplied to you in consideration of your agreement to the following terms. Your use, installation and/or redistribution of this Apple Software constitutes acceptance of these terms. If you do not agree with these terms, please do not use, install, or redistribute this Apple Software.

Provided you comply with all of the following terms, Apple grants you a personal, non-exclusive license, under Apple’s copyrights in the Apple Software, to use, reproduce, and redistribute the Apple Software for the sole purpose of creating Dashboard widgets for Mac OS X. If you redistribute the Apple Software, you must retain this entire notice in all such redistributions.

You may not use the name, trademarks, service marks or logos of Apple to endorse or promote products that include the Apple Software without the prior written permission of Apple. Except as expressly stated in this notice, no other rights or licenses, express or implied, are granted by Apple herein, including but not limited to any patent rights that may be infringed by your products that incorporate the Apple Software or by other works in which the Apple Software may be incorporated.

The Apple Software is provided on an "AS IS" basis.  APPLE MAKES NO WARRANTIES, EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION THE IMPLIED WARRANTIES OF NON-INFRINGEMENT, MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE, REGARDING THE APPPLE SOFTWARE OR ITS USE AND OPERATION ALONE OR IN COMBINATION WITH YOUR PRODUCTS.

IN NO EVENT SHALL APPLE BE LIABLE FOR ANY SPECIAL, INDIRECT, INCIDENTAL OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) ARISING IN ANY WAY OUT OF THE USE, REPRODUCTION, AND/OR DISTRIBUTION OF THE APPLE SOFTWARE, HOWEVER CAUSED AND WHETHER UNDER THEORY OF CONTRACT, TORT (INCLUDING NEGLIGENCE), STRICT LIABILITY OR OTHERWISE, EVEN IF APPLE HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

function CreateButton(buttonID, spec)
{
	var buttonElement = document.getElementById(buttonID);

	if (!buttonElement.loaded) {
		buttonElement.loaded = true;

		var text = spec.text || '';
		if (window.getLocalizedString) text = getLocalizedString(text);

		var imagePrefix = "Images/" + buttonID + "_";
		var leftImageWidth = spec.leftImageWidth || 0;
		var rightImageWidth = spec.rightImageWidth || 0;
        var width = getElementWidth(buttonElement) || 20;
		var height = getElementHeight(buttonElement) || 20;
		
		var onclick = spec.onclick || null;
		try { onclick = eval(onclick); } catch (e) { onclick = null; }

		buttonElement.object = new AppleButton(buttonElement, text, height, imagePrefix + "left.png", imagePrefix + "left_clicked.png", leftImageWidth, imagePrefix + "middle.png", imagePrefix + "middle_clicked.png", imagePrefix + "right.png", imagePrefix + "right_clicked.png", rightImageWidth, onclick);
		buttonElement.object._container.childNodes.item(2).style.width = rightImageWidth + "px";
		buttonElement.object.setEnabled(!spec.disabled);
		buttonElement.object.textElement.style.width = (width - (leftImageWidth + rightImageWidth)) + "px";
	}

	return buttonElement.object;
}
